/* ============ */
/* Roundl.c	*/
/* ============ */
#include <math.h>
/* ==================================================== */
/* Roundl - returns rounded integer of long double Tgt	*/
/* ==================================================== */
long double
Roundl(long double Tgt)
{
    long double  LrgstInt, FracPart;

    /* ------------------- */
    /* Get Largest Integer */
    /* ------------------- */
    LrgstInt = floorl(Tgt);

    /* ----------------- */
    /* Get Fraction Part */
    /* ----------------- */
    FracPart = Tgt - LrgstInt;

    if (FracPart < 0.5)
    {
	/* Do nothing (truncate) */
    }
    /* ----------------------- */
    /* Round if FracPart > 1/2 */
    /* ----------------------- */
    else if (FracPart > 0.5)
    {
	++LrgstInt;
    }
    else
    {
	/* --------------------------------- */
	/* If LrgstInt is odd, round to even */
	/* --------------------------------- */
	LrgstInt += LrgstInt - 2.0 * floorl(0.5 * LrgstInt);
    }

    return (LrgstInt);
}
